Attribute VB_Name = "FileMod"
'programmed by Anarki
'see Readme.txt for details

'<CodeStart>
Private Type CANAL
   Read As Byte
   Write As Byte
End Type
Dim CANAL As CANAL

Public MsgBoxResponse As Variant

Dim HomePath As String
Dim UserData As String
Dim FilePath As String
Dim a As Integer






   Private Sub GetHomePath()
   If Right(App.Path, 1) = "\" Then
      HomePath = App.Path
   Else:
      HomePath = App.Path & "\"
   End If
   End Sub






Public Sub LoadUserINI()
On Error GoTo DamagedINI
Dim INIPath As String

GetHomePath
INIPath = HomePath & "User.ini"
LoadDefaultINI:
If Dir(INIPath) = "" Then Err.Raise 11
CANAL.Read = FreeFile

Open INIPath For Input As #CANAL.Read
   LoadPARAMS_Common
   
   LoadPARAMS_CantorSet
   LoadPARAMS_Cross
   LoadPARAMS_SierpinskyGasket
   LoadPARAMS_KochCurve
   LoadPARAMS_LSystem
Close #CANAL.Read

Exit Sub
DamagedINI:
Close #CANAL.Read
Select Case INIPath
Case HomePath & "User.ini"
   MsgBoxResponse = MsgBox("User.ini seems to be damaged or lost." & vbCrLf & _
                           "The default settings will be loaded now." _
                           , vbCritical, "Bad Error:")
   INIPath = HomePath & "Default.ini"
   Resume LoadDefaultINI
   
Case HomePath & "Default.ini"
   MsgBoxResponse = MsgBox("Default.ini seems to be damaged or lost." & vbCrLf & _
                           "Please reinstall the programm in order to proceed." _
                           , vbCritical, "Fatal Error:")
   End
End Select
End Sub




   Private Sub LoadPARAMS_Common()
   With MainForm
      Input #CANAL.Read, UserData:   .FractalType_cmb.ListIndex = CByte(UserData)
      Input #CANAL.Read, UserData:   .Params_btn.Tag = IIf(UserData = 0, 1, 0): .Params_btn_Click
      
      Input #CANAL.Read, UserData:   .Left = CLng(UserData)
      Input #CANAL.Read, UserData:   .Top = CLng(UserData)
      Input #CANAL.Read, UserData:   .AreaWidth_txt.Text = UserData
      Input #CANAL.Read, UserData:   .AreaHeight_txt.Text = UserData
      .SetFormSize
      FindOptimalWindowPos
      
      Input #CANAL.Read, UserData:   .BackColor_pic.BackColor = CLng(UserData): .Output_pic.BackColor = CLng(UserData)
      Input #CANAL.Read, UserData:   .ForeColor_pic.BackColor = CLng(UserData): .Output_pic.ForeColor = CLng(UserData)
      Input #CANAL.Read, UserData:   .RandomForeColor_chk.Value = CByte(UserData)
      Input #CANAL.Read, UserData:   .CalcDepth_txt.Text = UserData
      Input #CANAL.Read, UserData:   .Pause_chk.Value = CByte(UserData)
   End With
   End Sub

      Private Sub FindOptimalWindowPos()
      With MainForm
         If .Left < 0 Then .Left = 0
         If .Left > Screen.Width - .Width Then .Left = Screen.Width - .Width
         If .Top < 0 Then .Top = 2
         If .Top > Screen.Height - (.Height + 400) Then .Top = Screen.Height - (.Height + 400)
      End With
      End Sub




   Private Sub LoadPARAMS_CantorSet()
   With PARAMS.CantorSet
      Input #CANAL.Read, UserData:   .DrawMode = CByte(UserData)
      For a = 0 To 1
         Input #CANAL.Read, UserData:   .Point(a).X = CDbl(UserData)
         Input #CANAL.Read, UserData:   .Point(a).Y = CDbl(UserData)
      Next a
      Input #CANAL.Read, UserData:   .StepHeight = CByte(UserData)
      Input #CANAL.Read, UserData:   .NewElementsCount = CByte(UserData)
   End With
   End Sub
   
   Private Sub LoadPARAMS_Cross()
   With PARAMS.Cross
      Input #CANAL.Read, UserData:   .DrawMode = CByte(UserData)
      Input #CANAL.Read, UserData:   ReDim .Point(CInt(UserData))
      For a = 0 To UBound(.Point())
         Input #CANAL.Read, UserData:   .Point(a).X = CDbl(UserData)
         Input #CANAL.Read, UserData:   .Point(a).Y = CDbl(UserData)
      Next a
      Input #CANAL.Read, UserData:   .ConnectLast = CBool(UserData)
      Line Input #CANAL.Read, UserData:   .DecreaseFactor = CDbl(UserData)
   End With
   End Sub
   
   Private Sub LoadPARAMS_SierpinskyGasket()
   With PARAMS.Sierpinsky
      Input #CANAL.Read, UserData:   .DrawMode = CByte(UserData)
      For a = 0 To 2
         Input #CANAL.Read, UserData:   .Point(a).X = CDbl(UserData)
         Input #CANAL.Read, UserData:   .Point(a).Y = CDbl(UserData)
      Next a
   End With
   End Sub
   
   Private Sub LoadPARAMS_KochCurve()
   With PARAMS.KochCurve
      Input #CANAL.Read, UserData:   .DrawMode = CByte(UserData)
      Input #CANAL.Read, UserData:   ReDim .Point(CInt(UserData))
      For a = 0 To UBound(.Point())
         Input #CANAL.Read, UserData:   .Point(a).X = CDbl(UserData)
         Input #CANAL.Read, UserData:   .Point(a).Y = CDbl(UserData)
      Next a
      Input #CANAL.Read, UserData:   .ConnectLast = CBool(UserData)
   End With
   End Sub
   
   Private Sub LoadPARAMS_LSystem()
   With PARAMS.LSystem
      For a = 0 To 1
         Input #CANAL.Read, UserData:   .Point(a).X = CDbl(UserData)
         Input #CANAL.Read, UserData:   .Point(a).Y = CDbl(UserData)
      Next a
      Input #CANAL.Read, UserData:   .Initiator = UserData
      Input #CANAL.Read, UserData:   .Generator = UserData
      Line Input #CANAL.Read, UserData:   .LineLength = CDbl(UserData)
      Line Input #CANAL.Read, UserData:   .Delta = CDbl(UserData)
   End With
   End Sub






':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::






Public Sub SaveUserINI()
If Dir(HomePath & "User.ini") <> "" Then Kill HomePath & "User.ini"
CANAL.Write = FreeFile

Open HomePath & "User.ini" For Output As #CANAL.Write
   SavePARAMS_Common
   
   SavePARAMS_CantorSet
   SavePARAMS_Cross
   SavePARAMS_SierpinskyGasket
   SavePARAMS_KochCurve
   SavePARAMS_LSystem
Close #CANAL.Write
End Sub



   
   Private Sub SavePARAMS_Common()
   With MainForm
      Print #CANAL.Write, .FractalType_cmb.ListIndex
      Print #CANAL.Write, .Params_btn.Tag

      Print #CANAL.Write, .Left
      Print #CANAL.Write, .Top
      Print #CANAL.Write, .AreaWidth_txt.Text
      Print #CANAL.Write, .AreaHeight_txt.Text
            
      Print #CANAL.Write, .BackColor_pic.BackColor
      Print #CANAL.Write, .ForeColor_pic.BackColor
      Print #CANAL.Write, .RandomForeColor_chk.Value
      Print #CANAL.Write, .CalcDepth_txt.Text
      Print #CANAL.Write, .Pause_chk.Value
   End With
   End Sub




   Private Sub SavePARAMS_CantorSet()
   With PARAMS.CantorSet
      Print #CANAL.Write, .DrawMode
      For a = 0 To 1
         Print #CANAL.Write, .Point(a).X
         Print #CANAL.Write, .Point(a).Y
      Next a
      Print #CANAL.Write, .StepHeight
      Print #CANAL.Write, .NewElementsCount
   End With
   End Sub
   
   Private Sub SavePARAMS_Cross()
   With PARAMS.Cross
      Print #CANAL.Write, .DrawMode
      Print #CANAL.Write, Str(UBound(.Point()))
      For a = 0 To UBound(.Point())
         Print #CANAL.Write, .Point(a).X
         Print #CANAL.Write, .Point(a).Y
      Next a
      Print #CANAL.Write, .ConnectLast
      Print #CANAL.Write, .DecreaseFactor
   End With
   End Sub
   
   Private Sub SavePARAMS_SierpinskyGasket()
   With PARAMS.Sierpinsky
      Print #CANAL.Write, .DrawMode
      For a = 0 To 2
         Print #CANAL.Write, .Point(a).X
         Print #CANAL.Write, .Point(a).Y
      Next a
   End With
   End Sub
   
   Private Sub SavePARAMS_KochCurve()
   With PARAMS.KochCurve
      Print #CANAL.Write, .DrawMode
      Print #CANAL.Write, Str(UBound(.Point()))
      For a = 0 To UBound(.Point())
         Print #CANAL.Write, .Point(a).X
         Print #CANAL.Write, .Point(a).Y
      Next a
      Print #CANAL.Write, .ConnectLast
   End With
   End Sub
   
   Private Sub SavePARAMS_LSystem()
   With PARAMS.LSystem
      For a = 0 To 1
         Print #CANAL.Write, .Point(a).X
         Print #CANAL.Write, .Point(a).Y
      Next a
      Print #CANAL.Write, .Initiator
      Print #CANAL.Write, .Generator
      Print #CANAL.Write, .LineLength
      Print #CANAL.Write, .Delta
   End With
   End Sub






':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::






Public Sub ImportFractalPARAMS()
FilePath = LoadFile(MainForm.CommonDialog)
If FilePath = "" Then Exit Sub
CANAL.Read = FreeFile

Open FilePath For Input As #CANAL.Read
   LoadPARAMS_Common
   
   Select Case MainForm.FractalType_cmb.ListIndex
   Case FT.CantorSet
      LoadPARAMS_CantorSet
   Case FT.Cross
      LoadPARAMS_Cross
   Case FT.SierpinskyGadget
      LoadPARAMS_SierpinskyGasket
   Case FT.KochCurve
      LoadPARAMS_KochCurve
   Case FT.LSystem
      LoadPARAMS_LSystem
   Case Else
      MsgBoxResponse = MsgBox("Parameter-File is damaged!", vbCritical, "Error:")
   End Select
Close #Read
End Sub




   Private Function LoadFile(ComDlgPointer As CommonDialog) As String
   On Error GoTo LoadFileDialogError
   
   With ComDlgPointer
      .InitDir = HomePath & "Saved Parameter\"
      .DialogTitle = "Paramaterdatei laden:"
      .Filter = "Parameter-Dateien (*.prm)|*.prm"
      .CancelError = False
      .Flags = cdlOFNHideReadOnly + _
               cdlOFNPathMustExist + _
               cdlOFNFileMustExist + _
               cdlOFNLongNames + _
               cdlOFNShareAware + _
               cdlOFNExplorer
      .ShowOpen
   
      LoadFile = .FileName
   
      Exit Function
LoadFileDialogError:
      Select Case Err.Number
      Case 32765
         MsgBoxResponse = MsgBox("Der 'Datei laden'-Dialog konnte wegen eines globalen Betriebssystemfehlers nicht geladen werden." & vbCrLf & _
                                 "Sie knnen nun immer noch den Pfad der Datei manuell angeben." & vbCrLf & _
                                 "Alternativ benutzen Sie Datei-Drag&Drop vom Explorer.", _
                                 vbCritical, "Fehler:")
RepeatFilePathInput:
         LoadFile = InputBox("Bitte tippen sie den vollstndigen Pfad der Datei manuell ein.", "Datei laden:")
         If LoadFile = "" Then Exit Function
         If Dir(LoadFile) = "" Then MsgBoxResponse = MsgBox("Dieser Dateipfad existiert nicht!", vbExclamation, "Error:"): GoTo RepeatFilePathInput
      Case 481
         MsgBoxResponse = MsgBox("Unbekanntes Format!", vbCritical, "Fehler:")
      Case Else
         MsgBoxResponse = MsgBox(Err.Number & vbCrLf & Err.Description, vbCritical, "Fataler Fehler:")
         MsgBoxResponse = MsgBox("Wiederholen - Versuchen die normale Programmausfhrung wieder aufzunehmen" & vbCrLf & "Abbrechen - Programm beenden", vbRetryCancel, "Auswahl:")
         If MsgBoxResponse = vbAbort Then Unload MainForm
         GoTo RepeatFilePathInput
      End Select
   End With
   End Function






':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::






Public Sub ExportFractalPARAMS()
FilePath = SaveFile(MainForm.CommonDialog)
If FilePath = "" Then Exit Sub
CANAL.Write = FreeFile

Open FilePath For Output As #CANAL.Write
   SavePARAMS_Common
   
   Select Case MainForm.FractalType_cmb.ListIndex
   Case FT.CantorSet
      SavePARAMS_CantorSet
   Case FT.Cross
      SavePARAMS_Cross
   Case FT.SierpinskyGadget
      SavePARAMS_SierpinskyGasket
   Case FT.KochCurve
      SavePARAMS_KochCurve
   Case FT.LSystem
      SavePARAMS_LSystem
   End Select
Close #CANAL.Write
End Sub




   Private Function SaveFile(ComDlgPointer As CommonDialog) As String
   On Error GoTo SaveFileDialogError
   
   With ComDlgPointer
      .InitDir = HomePath & "Saved Parameter\"
      .DialogTitle = "Paramaterdatei speichern:"
      .Filter = "Parameter-Dateien (*.prm)|*.prm"
      .DefaultExt = "prm"
      .CancelError = False
      .Flags = cdlOFNHideReadOnly + _
               cdlOFNOverwritePrompt + _
               cdlOFNPathMustExist + _
               cdlOFNShareAware + _
               cdlOFNExplorer
      .ShowSave
   
      SaveFile = .FileName
   
      Exit Function
SaveFileDialogError:
      Select Case Err.Number
      Case 32765
         MsgBoxResponse = MsgBox("Der 'Datei speichern'-Dialog konnte wegen eines globalen Betriebssystemfehlers nicht geladen werden." & vbCrLf & _
                                 "Sie knnen nun immer noch den Pfad manuell angeben.", _
                                 vbCritical, "Fehler:")
RepeatFilePathInput:
         SaveFile = InputBox("Bitte tippen sie den vollstndigen Speicher-Pfad manuell ein.", "Datei speichern:")
         If SaveFile = "" Then Exit Function
      Case Else
         MsgBoxResponse = MsgBox(Err.Number & vbCrLf & Err.Description, vbCritical, "Fataler Fehler:")
         MsgBoxResponse = MsgBox("Wiederholen - Versuchen die normale Programmausfhrung wieder aufzunehmen" & vbCrLf & "Abbrechen - Programm beenden", vbRetryCancel, "Auswahl:")
         If MsgBoxResponse = vbAbort Then Unload MainForm
         GoTo RepeatFilePathInput
      End Select
   End With
   End Function






':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::






   Public Function SavePic(ComDlgPointer As CommonDialog) As String
   On Error GoTo SaveFileDialogError
   
   With ComDlgPointer
      .InitDir = App.Path
      .DialogTitle = "Bild speichern:"
      .Filter = "Bitmap-Dateien (*.bmp)|*.bmp"
      .DefaultExt = "bmp"
      .CancelError = False
      .Flags = cdlOFNHideReadOnly + _
               cdlOFNOverwritePrompt + _
               cdlOFNPathMustExist + _
               cdlOFNShareAware + _
               cdlOFNExplorer
      .ShowSave
   
      SavePic = .FileName
   
      Exit Function
SaveFileDialogError:
      Select Case Err.Number
      Case 32765
         MsgBoxResponse = MsgBox("Der 'Bild speichern'-Dialog konnte wegen eines globalen Betriebssystemfehlers nicht geladen werden." & vbCrLf & _
                                 "Sie knnen nun immer noch den Pfad manuell angeben.", _
                                 vbCritical, "Fehler:")
RepeatFilePathInput:
         SavePic = InputBox("Bitte tippen sie den vollstndigen Speicher-Pfad manuell ein.", "Bild speichern:")
         If SavePic = "" Then Exit Function
      Case Else
         MsgBoxResponse = MsgBox(Err.Number & vbCrLf & Err.Description, vbCritical, "Fataler Fehler:")
         MsgBoxResponse = MsgBox("Wiederholen - Versuchen die normale Programmausfhrung wieder aufzunehmen" & vbCrLf & "Abbrechen - Programm beenden", vbRetryCancel, "Auswahl:")
         If MsgBoxResponse = vbAbort Then Unload MainForm
         GoTo RepeatFilePathInput
      End Select
   End With
   End Function
