Attribute VB_Name = "FractalityMod"
'programmed by Anarki
'see Readme.txt for details

'<CodeStart>
'DECLARATIONS:
Public Declare Sub Sleep Lib "kernel32" (ByVal Milliseconds As Long)
Private Declare Function SetPixelV Lib "gdi32" (ByVal HDC As Long, ByVal X As Long, ByVal Y As Long, ByVal Color As Long) As Long
Public Declare Function Polygon Lib "gdi32" (ByVal HDC As Long, Vertices As POINTAPI, ByVal nCount As Long) As Long

'STRUCTURES:
Private Type POINTAPI
   X As Long
   Y As Long
End Type

Private Type Point
   X As Double
   Y As Double
End Type

'//////////////////////

   Private Type General
      ScaleW As Long
      ScaleH As Long
      Color As Long
      CalcDepth As Long
      PauseAfterStep As Boolean
   End Type
   
   Private Type CantorSet
      DrawMode As Byte
      Point(0 To 1) As Point

      StepHeight As Integer
      NewElementsCount As Byte
   End Type

   Private Type Cross
      DrawMode As Byte
      Point() As Point
      ConnectLast As Boolean

      DecreaseFactor As Double
   End Type
   
   Private Type Sierpinsky
      DrawMode As Byte
      Point(0 To 2) As Point
   End Type
   
   Private Type KochCurve
      DrawMode As Byte
      Point() As Point
      ConnectLast As Boolean
   End Type
   
   Private Type LSystem
      Point(0 To 2) As Point
      
      Initiator As String
      Generator As String
      LineLength As Double
      Delta As Double
   End Type
   
Private Type PARAMS
   General As General
   CantorSet As CantorSet
   Cross As Cross
   Sierpinsky As Sierpinsky
   KochCurve As KochCurve
   LSystem As LSystem
End Type
Public PARAMS As PARAMS

'ENUMS:
Public Enum FT
   CantorSet = 0
   Cross = 1
   SierpinskyGadget = 2
   KochCurve = 3
   LSystem = 4
End Enum
Public FractalType() As String

Enum GS
   Ready = 0
   Working = 1
   Paused = 2
End Enum

'CONSTANTS:
Public Const PI = 3.141592654

'VARIABLES:
Public GlobalState As Byte

Dim a As Integer        'DepthCounter / InitLinesCounter / MiscCounter
Public OutputPointer As PictureBox

Dim RecursionsCount As Long
Dim ElementsCount As Long






Public Sub InitSys()
ReDim FractalType(4)
FractalType(0) = "Cantor Set"
FractalType(1) = "Cross"
FractalType(2) = "Sierpinsky's Gadget"
FractalType(3) = "Koch Curve"
FractalType(4) = "L-System"

For a = 0 To UBound(FractalType())
   MainForm.FractalType_cmb.AddItem FractalType(a)
Next a

Set OutputPointer = MainForm.Output_pic
End Sub




Public Sub DrawFractal(ChosenType As Byte)
Dim TurtleG As New TurtleGraphicsCls
Dim CurAlpha As Double

RecursionsCount = 0
ElementsCount = 0

OutputPointer.MousePointer = vbHourglass
OutputPointer.Cls

'Cantor
'PARAMS.CantorSet.StepHeight = 10          '10 Pixel hoch

'Cross
'PARAMS.Cross.DecreaseFactor = 0.5

Select Case ChosenType
Case FT.CantorSet
   If PARAMS.CantorSet.DrawMode = DM.Recursive Then DF_CantorSet_Recursive
   If PARAMS.CantorSet.DrawMode = DM.Demo Then DF_CantorSet_Demo
Case FT.Cross
   If PARAMS.Cross.DrawMode = DM.Recursive Then DF_Cross_Recursive
Case FT.SierpinskyGadget
   If PARAMS.Sierpinsky.DrawMode = DM.Recursive Then DF_Sierpinsky_Recursive
   If PARAMS.Sierpinsky.DrawMode = DM.ChaosGame Then DF_Sierpinsky_ChaosGame
   If PARAMS.Sierpinsky.DrawMode = DM.Demo Then DF_Sierpinsky_Demo
Case FT.KochCurve
   If PARAMS.KochCurve.DrawMode = DM.Recursive Then DF_KochCurve_Recursive
   If PARAMS.KochCurve.DrawMode = DM.TurtleGraphics Then
      TurtleG.SetStartStates PARAMS.KochCurve.Point(0).X, PARAMS.KochCurve.Point(0).Y, _
                             GetCurAlpha(PARAMS.KochCurve.Point(0).X, PARAMS.KochCurve.Point(1).X, PARAMS.KochCurve.Point(0).Y, PARAMS.KochCurve.Point(1).Y)

      TurtleG.InitiatorString = "F--F--F"
      TurtleG.GeneratorString = "F+F--F+F"

      TurtleG.Distance = Sqr((PARAMS.KochCurve.Point(1).X - PARAMS.KochCurve.Point(0).X) ^ 2 + _
                            (PARAMS.KochCurve.Point(1).Y - PARAMS.KochCurve.Point(0).Y) ^ 2) * _
                            (1 / (3 ^ PARAMS.General.CalcDepth))
      TurtleG.Delta = (60 / 180) * PI      '60
      TurtleG.Depth = PARAMS.General.CalcDepth
      
      TurtleG.Draw
   End If
Case FT.LSystem
   TurtleG.SetStartStates PARAMS.LSystem.Point(0).X, PARAMS.LSystem.Point(0).Y, _
                          GetCurAlpha(PARAMS.LSystem.Point(0).X, PARAMS.LSystem.Point(1).X, PARAMS.LSystem.Point(0).Y, PARAMS.LSystem.Point(1).Y)

   TurtleG.InitiatorString = PARAMS.LSystem.Initiator
   TurtleG.GeneratorString = PARAMS.LSystem.Generator
   TurtleG.Distance = PARAMS.LSystem.LineLength
   TurtleG.Delta = (PARAMS.LSystem.Delta / 180) * PI
   TurtleG.Depth = PARAMS.General.CalcDepth
   
   TurtleG.Draw
End Select

OutputPointer.MousePointer = 0
End Sub
   
   Private Function GetCurAlpha(X1 As Double, X2 As Double, Y1 As Double, Y2 As Double) As Double
   Select Case Sgn(X2 - X1)
   Case 1
      GetCurAlpha = Atn((Y2 - Y1) / (X2 - X1))
   Case 0
      GetCurAlpha = (PI / 2) * Sgn(Y2 - Y1)
   Case -1
      GetCurAlpha = PI + Atn((Y2 - Y1) / (X2 - X1))
   End Select
   End Function










'///////////////////////////////////////////////////////////////////////////////
'*** CANTOR **********************************************************************
'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

   Private Sub DF_CantorSet_Recursive()
   With PARAMS.CantorSet
      .NewElementsCount = .NewElementsCount * 2 - 1
      OutputPointer.Line (.Point(0).X, .Point(0).Y)-(.Point(1).X, .Point(0).Y + .StepHeight), GetColor, BF
      IncreaseElementsCount 1
      CantorSet_Main .Point(0).X, .Point(1).X, .Point(0).Y + .StepHeight, 1
   End With
   End Sub
      
      Private Sub CantorSet_Main(X1 As Double, X2 As Double, Y As Double, CurDepth As Integer)
      Dim b As Long
      Dim NewX1 As Double, NewX2 As Double
      
      If CurDepth > PARAMS.General.CalcDepth Then Exit Sub
      
      With PARAMS.CantorSet
         For b = 0 To .NewElementsCount Step 2
            If GlobalState = GS.Paused Then PauseMode
            If GlobalState = GS.Ready Then Exit Sub
         
            NewX1 = (b / .NewElementsCount) * (X2 - X1) + X1
            NewX2 = (b + 1) / .NewElementsCount * (X2 - X1) + X1
            
            OutputPointer.Line (NewX1, Y)-(NewX2, Y + .StepHeight), GetColor, BF
            IncreaseRecursionsCount 1
            IncreaseElementsCount 1
            DoEvents
            CantorSet_Main NewX1, NewX2, Y + .StepHeight, CurDepth + 1
         Next b
      End With
      End Sub




   Private Sub DF_CantorSet_Demo()
   Dim LastStep() As Double
   Dim NewStep() As Double
   
   Dim D As Long           'DepthCounter
   Dim C As Long           'Counter fr NewStep()
   Dim CurColor As Long    'Farbverlauf
   
   ReDim LastStep(0)
   LastStep(0) = 0
   CurColor = 0
   OutputPointer.Line (0, 0)- _
                      (OutputPointer.ScaleWidth, PARAMS.CantorSet.StepHeight), _
                      GetColor, BF
   
   For D = 1 To PARAMS.General.CalcDepth
      ReDim NewStep(2 ^ D)
      C = 0
      CurColor = (&HE0E0E0 / PARAMS.General.CalcDepth) * (D)
      
      For a = 0 To UBound(LastStep())
         If GlobalState = GS.Paused Then PauseMode
         If GlobalState = GS.Ready Then Exit Sub

         NewStep(C) = LastStep(a)
         C = C + 1
         NewStep(C) = NewStep(C - 1) + (1 / (3 ^ D))
         
         OutputPointer.Line (NewStep(C - 1) * OutputPointer.ScaleWidth, PARAMS.CantorSet.StepHeight * D)- _
                            (NewStep(C) * OutputPointer.ScaleWidth, PARAMS.CantorSet.StepHeight * (D + 1)), _
                            CurColor, BF
   
         NewStep(C) = LastStep(a) + (2 / (3 ^ D))
         C = C + 1
         NewStep(C) = NewStep(C - 1) + (1 / (3 ^ D))
         
         OutputPointer.Line (NewStep(C - 1) * OutputPointer.ScaleWidth, PARAMS.CantorSet.StepHeight * D)- _
                            (NewStep(C) * OutputPointer.ScaleWidth, PARAMS.CantorSet.StepHeight * (D + 1)), _
                            CurColor, BF
                            
         IncreaseElementsCount 2
         DoEvents
      Next a
      
      ReDim Preserve NewStep(UBound(NewStep()) - 1)
      LastStep() = NewStep()
   Next D
   End Sub

'////////////////////////////////////////////////////////////////////////////
'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\



   
   
   
   
   
   
   
   
'///////////////////////////////////////////////////////////////////////////////
'*** CROSS **********************************************************************
'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
   
   Private Sub DF_Cross_Recursive()
   With PARAMS.Cross
      For a = 0 To UBound(.Point()) - 1
         If GlobalState = GS.Ready Then Exit Sub
         OutputPointer.Line (.Point(a).X, .Point(a).Y)-(.Point(a + 1).X, .Point(a + 1).Y), GetColor
         IncreaseElementsCount 1
         Cross_Main .Point(a).X, .Point(a + 1).X, .Point(a).Y, .Point(a + 1).Y, 1
      Next a
      If .ConnectLast = True Then
         If GlobalState = GS.Ready Then Exit Sub
         OutputPointer.Line (.Point(a).X, .Point(a).Y)-(.Point(0).X, .Point(0).Y), GetColor
         IncreaseElementsCount 1
         Cross_Main .Point(a).X, .Point(0).X, .Point(a).Y, .Point(0).Y, 1
      End If
   End With
   End Sub
   
      Private Sub Cross_Main(X1 As Double, X2 As Double, Y1 As Double, Y2 As Double, CurDepth As Integer)
      On Error Resume Next
      Dim Delta As Double
      Dim NewPoints(0 To 2) As Point
      
      If GlobalState = GS.Paused Then PauseMode
      If GlobalState = GS.Ready Then Exit Sub
      If CurDepth > PARAMS.General.CalcDepth Then Exit Sub
      Delta = PARAMS.Cross.DecreaseFactor ^ 2
      
      'First new point [--]
      NewPoints(0).X = X1 + (X2 - X1) / 2
      NewPoints(0).Y = Y1 + (Y2 - Y1) / 2
      
      'Second new point [-|-]
      NewPoints(1).X = NewPoints(0).X - (Y2 - Y1) * Delta
      NewPoints(1).Y = NewPoints(0).Y - (X2 - X1) * Delta
      
      'Third new point [-|-]
      NewPoints(2).X = NewPoints(0).X + (Y2 - Y1) * Delta
      NewPoints(2).Y = NewPoints(0).Y + (X2 - X1) * Delta
      
      OutputPointer.Line (NewPoints(1).X, NewPoints(1).Y)-(NewPoints(2).X, NewPoints(2).Y), GetColor
      IncreaseRecursionsCount 1
      IncreaseElementsCount 1
      DoEvents
      
      Cross_Main NewPoints(0).X, X1, NewPoints(0).Y, Y1, CurDepth + 1
      Cross_Main NewPoints(0).X, X2, NewPoints(0).Y, Y2, CurDepth + 1
      Cross_Main NewPoints(0).X, NewPoints(1).X, NewPoints(0).Y, NewPoints(1).Y, CurDepth + 1
      Cross_Main NewPoints(0).X, NewPoints(2).X, NewPoints(0).Y, NewPoints(2).Y, CurDepth + 1
      End Sub
      
'////////////////////////////////////////////////////////////////////////////
'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\











'///////////////////////////////////////////////////////////////////////////////
'*** SIERPINSKY **********************************************************************
'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

   Private Sub DF_Sierpinsky_Recursive()
   Dim StartTriVertices(0 To 2) As POINTAPI
   
   With PARAMS.Sierpinsky
      StartTriVertices(0).X = .Point(0).X
      StartTriVertices(1).X = .Point(1).X
      StartTriVertices(2).X = .Point(2).X
      StartTriVertices(0).Y = .Point(0).Y
      StartTriVertices(1).Y = .Point(1).Y
      StartTriVertices(2).Y = .Point(2).Y
      
      OutputPointer.FillColor = OutputPointer.ForeColor
      Polygon OutputPointer.HDC, StartTriVertices(0), 3
      
      Sierpinsky_Main StartTriVertices(0).X, StartTriVertices(1).X, StartTriVertices(2).X, _
                      StartTriVertices(0).Y, StartTriVertices(1).Y, StartTriVertices(2).Y, 1
   End With
   End Sub
      
      Private Sub Sierpinsky_Main(X1 As Long, X2 As Long, X3 As Long, _
                                  Y1 As Long, Y2 As Long, Y3 As Long, CurDepth As Integer)
      Dim NewTriVertices(0 To 2) As POINTAPI
      
      If CurDepth > PARAMS.General.CalcDepth Then Exit Sub
      If GlobalState = GS.Paused Then PauseMode
      If GlobalState = GS.Ready Then Exit Sub

      'First new point
      NewTriVertices(0).X = X1 + (X2 - X1) / 2
      NewTriVertices(0).Y = Y1 + (Y2 - Y1) / 2
      
      'Second new point
      NewTriVertices(1).X = X2 + (X3 - X2) / 2
      NewTriVertices(1).Y = Y2 + (Y3 - Y2) / 2
      
      'Third new point
      NewTriVertices(2).X = X1 + (X3 - X1) / 2
      NewTriVertices(2).Y = Y1 + (Y3 - Y1) / 2
      
      OutputPointer.FillColor = GetColor
      Polygon OutputPointer.HDC, NewTriVertices(0), 3
      IncreaseRecursionsCount 1
      IncreaseElementsCount 1
      OutputPointer.Refresh
      DoEvents
      
      Sierpinsky_Main X1, NewTriVertices(0).X, NewTriVertices(2).X, _
                      Y1, NewTriVertices(0).Y, NewTriVertices(2).Y, CurDepth + 1
      Sierpinsky_Main NewTriVertices(0).X, X2, NewTriVertices(1).X, _
                      NewTriVertices(0).Y, Y2, NewTriVertices(1).Y, CurDepth + 1
      Sierpinsky_Main NewTriVertices(2).X, NewTriVertices(1).X, X3, _
                      NewTriVertices(2).Y, NewTriVertices(1).Y, Y3, CurDepth + 1
      End Sub




   Private Sub DF_Sierpinsky_ChaosGame()
   Dim X As Double, Y As Double        'CurPixelCoordinates
   Dim n As Single
   
   Randomize
   X = Rnd: Y = Rnd
   
   For a = 1 To PARAMS.General.CalcDepth
      If GlobalState = GS.Paused Then PauseMode
      If GlobalState = GS.Ready Then Exit Sub
   
      n = Rnd
      Select Case n
      Case Is <= (1 / 3)
         X = X / 2
         Y = Y / 2
      Case Is >= (2 / 3)
         X = (1 + X) / 2
         Y = Y / 2
      Case Else         '>= 0,33 + <=0,66
         X = (0.5 + X) / 2
         Y = (1 + Y) / 2
      End Select
            
      SetPixelV OutputPointer.HDC, CLng(X * OutputPointer.ScaleWidth), CLng(Y * OutputPointer.ScaleHeight), GetColor
      IncreaseElementsCount 1
      If a Mod 10 = 0 Then
         OutputPointer.Refresh
         DoEvents
      End If
   Next a
   End Sub




   Private Sub DF_Sierpinsky_Demo()
   Dim X As Double, Y As Double        'CurPixelCoordinates
   Dim XO As Double, YO As Double      'LastPixelCoordinates
   Dim n As Single
   
   Randomize
   X = Rnd: Y = Rnd
   OutputPointer.Circle (CLng(X * OutputPointer.ScaleWidth), CLng(Y * OutputPointer.ScaleHeight)), 2, RGB(0, 255, 0)
   
   For a = 1 To PARAMS.General.CalcDepth
      If GlobalState = GS.Paused Then PauseMode
      If GlobalState = GS.Ready Then Exit Sub
      
      n = Rnd
      XO = X: YO = Y
      Select Case n
      Case Is <= (1 / 3)
         X = X / 2
         Y = Y / 2
      Case Is >= (2 / 3)
         X = (1 + X) / 2
         Y = Y / 2
      Case Else         '>= 0,33 + <=0,66
         X = (0.5 + X) / 2
         Y = (1 + Y) / 2
      End Select
      
      OutputPointer.Line (XO * OutputPointer.ScaleWidth, YO * OutputPointer.ScaleHeight)-(X * OutputPointer.ScaleWidth, Y * OutputPointer.ScaleHeight), RGB(192, 192, 192)
      OutputPointer.Circle (CLng(X * OutputPointer.ScaleWidth), CLng(Y * OutputPointer.ScaleHeight)), 2, RGB(255, 0, 0)
      IncreaseElementsCount 1
      Sleep 100
      OutputPointer.Refresh
      DoEvents
   Next a
   End Sub
   
'////////////////////////////////////////////////////////////////////////////
'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\











'///////////////////////////////////////////////////////////////////////////////
'*** KOCH **********************************************************************
'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
   
   Private Sub DF_KochCurve_Recursive()
   With PARAMS.KochCurve
      For a = 0 To UBound(.Point()) - 1
         If GlobalState = GS.Ready Then Exit Sub
         OutputPointer.Line (.Point(a).X, .Point(a).Y)-(.Point(a + 1).X, .Point(a + 1).Y), GetColor
         IncreaseElementsCount 1
         KochCurve_Main .Point(a).X, .Point(a + 1).X, .Point(a).Y, .Point(a + 1).Y, 1
      Next a
      If .ConnectLast = True Then
         If GlobalState = GS.Ready Then Exit Sub
         OutputPointer.Line (.Point(a).X, .Point(a).Y)-(.Point(0).X, .Point(0).Y), GetColor
         IncreaseElementsCount 1
         KochCurve_Main .Point(a).X, .Point(0).X, .Point(a).Y, .Point(0).Y, 1
      End If
   End With
   End Sub
            
      Private Sub KochCurve_Main(X1 As Double, X2 As Double, Y1 As Double, Y2 As Double, CurDepth As Integer)
      Dim NewPoints(0 To 2) As Point
      Const Delta = 0.285
   
      If CurDepth > PARAMS.General.CalcDepth Then Exit Sub
      If GlobalState = GS.Paused Then PauseMode
      If GlobalState = GS.Ready Then Exit Sub
      
      'First new point
      NewPoints(0).X = X1 + (X2 - X1) / 3
      NewPoints(0).Y = Y1 + (Y2 - Y1) / 3
      
      'Second new point (Top of triangle)
      NewPoints(1).X = (X1 + X2) / 2 + (Y2 - Y1) * Delta
      NewPoints(1).Y = (Y1 + Y2) / 2 - (X2 - X1) * Delta
      
      'Third new point
      NewPoints(2).X = X2 - (X2 - X1) / 3
      NewPoints(2).Y = Y2 - (Y2 - Y1) / 3
      
      'zweite Drittel der Strecke lschen:
      'OutputPointer.Line (NewPoints(0).X, NewPoints(0).Y)-(NewPoints(2).X, NewPoints(2).Y), MainForm.Output_pic.BackColor

      OutputPointer.Line (NewPoints(0).X, NewPoints(0).Y)-(NewPoints(1).X, NewPoints(1).Y), GetColor
      OutputPointer.Line (NewPoints(1).X, NewPoints(1).Y)-(NewPoints(2).X, NewPoints(2).Y), GetColor
      IncreaseElementsCount 2
      IncreaseRecursionsCount 1
      DoEvents
      
      KochCurve_Main X1, NewPoints(0).X, Y1, NewPoints(0).Y, CurDepth + 1
      KochCurve_Main NewPoints(0).X, NewPoints(1).X, NewPoints(0).Y, NewPoints(1).Y, CurDepth + 1
      KochCurve_Main NewPoints(1).X, NewPoints(2).X, NewPoints(1).Y, NewPoints(2).Y, CurDepth + 1
      KochCurve_Main NewPoints(2).X, X2, NewPoints(2).Y, Y2, CurDepth + 1
      End Sub
      
'////////////////////////////////////////////////////////////////////////////
'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\











'### COMMOM FUNCTIONS ##########################################################

Public Function GetColor() As Long
If PARAMS.General.Color = -1 Then
   Randomize
   Do
      GetColor = QBColor(Int(Rnd * 16))
   Loop Until GetColor <> MainForm.BackColor_pic.BackColor
Else:
   GetColor = PARAMS.General.Color
End If
End Function




Public Sub PauseMode()
Do
   If GlobalState <> GS.Paused Then Exit Do
   Sleep 100
   DoEvents
Loop
If GlobalState = GS.Ready Then Exit Sub
If PARAMS.General.PauseAfterStep = True Then MainForm.ManageGlobalStates GS.Paused
End Sub




Public Sub IncreaseElementsCount(IncreaseVal As Integer)
ElementsCount = ElementsCount + IncreaseVal

If GlobalState = GS.Paused Then GoTo RefreshElementsCount
If ElementsCount Mod 15 = 0 Then
RefreshElementsCount:
   Sleep 10
   MainForm.StatusBar.Panels("ElementsCount").Text = "Elements drawn: " & ElementsCount
End If
End Sub

Public Sub IncreaseRecursionsCount(IncreaseVal As Integer)
RecursionsCount = RecursionsCount + IncreaseVal

If GlobalState = GS.Paused Then GoTo RefreshRecursionsCount
If RecursionsCount Mod 15 = 0 Then
RefreshRecursionsCount:
   MainForm.StatusBar.Panels("RecursionsCount").Text = "Recursions: " & RecursionsCount
End If
End Sub
'###########################################################################
