VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form MainForm 
   Caption         =   "Fractality"
   ClientHeight    =   4680
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7425
   Icon            =   "MainForm.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4680
   ScaleWidth      =   7425
   StartUpPosition =   3  'Windows-Standard
   Begin VB.Timer Unload_tmr 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   7000
      Top             =   0
   End
   Begin VB.PictureBox GSIcon_pic 
      AutoSize        =   -1  'True
      BackColor       =   &H00000000&
      BorderStyle     =   0  'Kein
      Height          =   240
      Index           =   2
      Left            =   480
      Picture         =   "MainForm.frx":0E42
      ScaleHeight     =   16
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   16
      TabIndex        =   49
      Top             =   4140
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.PictureBox GSIcon_pic 
      AutoSize        =   -1  'True
      BackColor       =   &H00000000&
      BorderStyle     =   0  'Kein
      Height          =   240
      Index           =   1
      Left            =   240
      Picture         =   "MainForm.frx":11B5
      ScaleHeight     =   16
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   16
      TabIndex        =   48
      Top             =   4140
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.PictureBox GSIcon_pic 
      AutoSize        =   -1  'True
      BackColor       =   &H00000000&
      BorderStyle     =   0  'Kein
      Height          =   240
      Index           =   0
      Left            =   0
      Picture         =   "MainForm.frx":14F1
      ScaleHeight     =   16
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   16
      TabIndex        =   47
      Top             =   4140
      Visible         =   0   'False
      Width           =   240
   End
   Begin MSComctlLib.StatusBar StatusBar 
      Align           =   2  'Unten ausrichten
      Height          =   300
      Left            =   0
      TabIndex        =   46
      Top             =   4380
      Width           =   7425
      _ExtentX        =   13097
      _ExtentY        =   529
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   4
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Alignment       =   1
            Object.Width           =   441
            MinWidth        =   441
            Key             =   "GlobalState"
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Object.Width           =   2893
            MinWidth        =   2893
            Text            =   "Recursions: 0"
            TextSave        =   "Recursions: 0"
            Key             =   "RecursionsCount"
         EndProperty
         BeginProperty Panel3 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Object.Width           =   3466
            MinWidth        =   3466
            Text            =   "Elements drawn: 0"
            TextSave        =   "Elements drawn: 0"
            Key             =   "ElementsCount"
         EndProperty
         BeginProperty Panel4 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Alignment       =   2
            AutoSize        =   1
            Bevel           =   0
            Object.Width           =   5715
            Text            =   "start drawing with RETURN"
            TextSave        =   "start drawing with RETURN"
            Key             =   "Help"
         EndProperty
      EndProperty
   End
   Begin VB.CommandButton Export_btn 
      Caption         =   "&Export"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   5330
      TabIndex        =   5
      Tag             =   "1"
      Top             =   100
      Width           =   1200
   End
   Begin VB.CommandButton Import_btn 
      Caption         =   "&Import"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   4130
      TabIndex        =   4
      Tag             =   "1"
      Top             =   100
      Width           =   1200
   End
   Begin MSComDlg.CommonDialog CommonDialog 
      Left            =   0
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Frame DrawModes_frm 
      Caption         =   "Draw Modes:"
      Height          =   1450
      Left            =   5330
      TabIndex        =   21
      ToolTipText     =   "for detailed information open the Readme-File"
      Top             =   500
      Width           =   2000
      Begin VB.OptionButton DrawMode_opt 
         Caption         =   "Turtle Graphics"
         Height          =   200
         Index           =   2
         Left            =   150
         TabIndex        =   24
         Top             =   850
         Width           =   1700
      End
      Begin VB.OptionButton DrawMode_opt 
         Caption         =   "Demo"
         Height          =   200
         Index           =   3
         Left            =   150
         TabIndex        =   25
         Top             =   1100
         Width           =   1700
      End
      Begin VB.OptionButton DrawMode_opt 
         Caption         =   "Chaos Game"
         Height          =   200
         Index           =   1
         Left            =   150
         TabIndex        =   23
         Top             =   600
         Width           =   1700
      End
      Begin VB.OptionButton DrawMode_opt 
         Caption         =   "Recursive"
         Height          =   200
         Index           =   0
         Left            =   150
         TabIndex        =   22
         Top             =   350
         Width           =   1700
      End
   End
   Begin VB.Frame CommonParameter_frm 
      Caption         =   "Common Parameter:"
      Height          =   3780
      Left            =   3230
      TabIndex        =   7
      Top             =   500
      Width           =   2000
      Begin VB.CommandButton SpecialParams_btn 
         Caption         =   "> &Switch to Special >"
         Height          =   300
         Left            =   100
         TabIndex        =   20
         Top             =   3387
         Width           =   1800
      End
      Begin VB.CheckBox Pause_chk 
         Caption         =   "Pause after each op."
         Height          =   200
         Left            =   100
         TabIndex        =   19
         Top             =   2980
         Width           =   1800
      End
      Begin VB.CheckBox RandomForeColor_chk 
         Caption         =   "Random ForeColor"
         Height          =   200
         Left            =   150
         TabIndex        =   16
         Top             =   2100
         Width           =   1700
      End
      Begin VB.TextBox AreaHeight_txt 
         Alignment       =   2  'Zentriert
         Height          =   300
         Left            =   1050
         MaxLength       =   3
         TabIndex        =   12
         Text            =   "250"
         Top             =   700
         Width           =   500
      End
      Begin VB.TextBox AreaWidth_txt 
         Alignment       =   2  'Zentriert
         Height          =   300
         Left            =   1050
         MaxLength       =   3
         TabIndex        =   9
         Text            =   "200"
         Top             =   350
         Width           =   500
      End
      Begin VB.PictureBox BackColor_pic 
         AutoRedraw      =   -1  'True
         BackColor       =   &H00FFFFFF&
         Height          =   350
         Left            =   150
         ScaleHeight     =   285
         ScaleWidth      =   1635
         TabIndex        =   14
         Top             =   1300
         Width           =   1700
      End
      Begin VB.PictureBox ForeColor_pic 
         AutoRedraw      =   -1  'True
         BackColor       =   &H00000000&
         Height          =   350
         Left            =   150
         ScaleHeight     =   285
         ScaleWidth      =   1635
         TabIndex        =   15
         Top             =   1700
         Width           =   1700
      End
      Begin VB.TextBox CalcDepth_txt 
         Height          =   300
         Left            =   1000
         TabIndex        =   18
         Text            =   "10"
         Top             =   2565
         Width           =   850
      End
      Begin VB.Line Separator3Line1 
         BorderColor     =   &H00808080&
         X1              =   0
         X2              =   2195
         Y1              =   3280
         Y2              =   3280
      End
      Begin VB.Line Separator3Line2 
         BorderColor     =   &H00FFFFFF&
         X1              =   15
         X2              =   1985
         Y1              =   3295
         Y2              =   3295
      End
      Begin VB.Label AreaHeightDescription_lbl 
         Caption         =   "Pixel"
         Height          =   195
         Left            =   1580
         TabIndex        =   13
         Top             =   750
         Width           =   350
      End
      Begin VB.Label AreaWidthDescription_lbl 
         Caption         =   "Pixel"
         Height          =   195
         Left            =   1580
         TabIndex        =   10
         Top             =   400
         Width           =   350
      End
      Begin VB.Line Separator2Line2 
         BorderColor     =   &H00FFFFFF&
         X1              =   15
         X2              =   2000
         Y1              =   2415
         Y2              =   2415
      End
      Begin VB.Line Separator2Line1 
         BorderColor     =   &H00808080&
         X1              =   0
         X2              =   1985
         Y1              =   2400
         Y2              =   2400
      End
      Begin VB.Line Separator1Line2 
         BorderColor     =   &H00808080&
         X1              =   0
         X2              =   1985
         Y1              =   1150
         Y2              =   1150
      End
      Begin VB.Line Separator1Line1 
         BorderColor     =   &H00FFFFFF&
         X1              =   15
         X2              =   1985
         Y1              =   1165
         Y2              =   1165
      End
      Begin VB.Label AreaWidth_lbl 
         Caption         =   "AreaWidth:"
         Height          =   195
         Left            =   150
         TabIndex        =   8
         Top             =   405
         Width           =   850
      End
      Begin VB.Label AreaHeight_lbl 
         Caption         =   "AreaHeight:"
         Height          =   195
         Left            =   150
         TabIndex        =   11
         Top             =   750
         Width           =   850
      End
      Begin VB.Label CalcDepth_lbl 
         Caption         =   "CalcDepth:"
         Height          =   195
         Left            =   150
         TabIndex        =   17
         Top             =   2615
         Width           =   795
      End
   End
   Begin VB.CommandButton Params_btn 
      Caption         =   "<<& "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   2825
      TabIndex        =   2
      Tag             =   "1"
      ToolTipText     =   "Close/Open ParameterBar"
      Top             =   100
      Width           =   400
   End
   Begin VB.CommandButton Draw_btn 
      Caption         =   "&Draw Fractal"
      Default         =   -1  'True
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   1325
      TabIndex        =   1
      Top             =   100
      Width           =   1500
   End
   Begin VB.ComboBox FractalType_cmb 
      Height          =   315
      ItemData        =   "MainForm.frx":185A
      Left            =   100
      List            =   "MainForm.frx":185C
      Style           =   2  'Dropdown-Liste
      TabIndex        =   0
      Top             =   100
      Width           =   1225
   End
   Begin VB.PictureBox Output_pic 
      Appearance      =   0  '2D
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000005&
      FillStyle       =   0  'Ausgefllt
      ForeColor       =   &H80000008&
      Height          =   3780
      Left            =   100
      ScaleHeight     =   250
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   200
      TabIndex        =   6
      Top             =   500
      Width           =   3030
      Begin VB.Image FixPoint_img 
         Height          =   150
         Index           =   0
         Left            =   0
         Picture         =   "MainForm.frx":185E
         Top             =   0
         Width           =   150
      End
   End
   Begin VB.Frame LSystem_frm 
      Caption         =   "LSystem Special:"
      Height          =   2220
      Left            =   5330
      TabIndex        =   50
      Top             =   2050
      Visible         =   0   'False
      Width           =   2000
      Begin VB.TextBox Delta_txt 
         Alignment       =   2  'Zentriert
         Height          =   300
         Left            =   1005
         TabIndex        =   57
         Text            =   "50"
         ToolTipText     =   "should lie somewhere between -360 and 360"
         Top             =   1830
         Width           =   900
      End
      Begin VB.TextBox LineLength_txt 
         Alignment       =   2  'Zentriert
         Height          =   300
         Left            =   1000
         TabIndex        =   55
         Text            =   "0.5"
         ToolTipText     =   "[Pixel]   (the higher the Depth the lower this value should be)"
         Top             =   1450
         Width           =   900
      End
      Begin VB.TextBox Generator_txt 
         Height          =   300
         Left            =   100
         TabIndex        =   53
         Text            =   "F[+F]F[-F]F"
         Top             =   1050
         Width           =   1800
      End
      Begin VB.TextBox Initiator_txt 
         Height          =   300
         Left            =   100
         TabIndex        =   51
         Text            =   "F"
         Top             =   500
         Width           =   1800
      End
      Begin VB.Label Delta_lbl 
         Caption         =   "Angel Delta:"
         Height          =   195
         Left            =   105
         TabIndex        =   58
         Top             =   1880
         Width           =   900
      End
      Begin VB.Label LineLength_lbl 
         Caption         =   "LineLength:"
         Height          =   195
         Left            =   100
         TabIndex        =   56
         Top             =   1550
         Width           =   900
      End
      Begin VB.Label Generator_lbl 
         Alignment       =   2  'Zentriert
         Caption         =   "Generator::::::::::::::::::::::::"
         Height          =   195
         Left            =   100
         TabIndex        =   54
         Top             =   850
         Width           =   1800
      End
      Begin VB.Label Initiator_lbl 
         Alignment       =   2  'Zentriert
         Caption         =   "Initiator::::::::::::::::::::::::::::"
         Height          =   195
         Left            =   100
         TabIndex        =   52
         Top             =   300
         Width           =   1800
      End
   End
   Begin VB.Frame FixPoints_frm 
      Caption         =   "FixPoints:"
      Height          =   2220
      Left            =   5330
      TabIndex        =   26
      Top             =   2050
      Width           =   2000
      Begin VB.Frame OutsideContainer_frm 
         BorderStyle     =   0  'Kein
         Height          =   1420
         Left            =   100
         TabIndex        =   29
         Top             =   700
         Width           =   1800
         Begin VB.Frame InsideContainer_frm 
            BorderStyle     =   0  'Kein
            Height          =   4500
            Left            =   0
            TabIndex        =   30
            Top             =   0
            Width           =   1575
            Begin VB.CheckBox ConnectLast_chk 
               Caption         =   "Connect last FixPoint with first"
               Height          =   400
               Left            =   0
               TabIndex        =   35
               Top             =   500
               Width           =   1575
            End
            Begin VB.TextBox YPos_txt 
               Alignment       =   2  'Zentriert
               Height          =   300
               Index           =   0
               Left            =   1075
               MaxLength       =   4
               TabIndex        =   34
               Text            =   "0"
               Top             =   100
               Width           =   400
            End
            Begin VB.TextBox XPos_txt 
               Alignment       =   2  'Zentriert
               Height          =   300
               Index           =   0
               Left            =   325
               MaxLength       =   4
               TabIndex        =   32
               Text            =   "0"
               Top             =   100
               Width           =   400
            End
            Begin VB.Label YPos_lbl 
               BackStyle       =   0  'Transparent
               Caption         =   "Y1:"
               Height          =   195
               Index           =   0
               Left            =   825
               TabIndex        =   33
               Top             =   150
               Width           =   250
            End
            Begin VB.Label XPos_lbl 
               BackStyle       =   0  'Transparent
               Caption         =   "X1:"
               Height          =   195
               Index           =   0
               Left            =   75
               TabIndex        =   31
               Top             =   150
               Width           =   250
            End
         End
         Begin VB.VScrollBar FixPointsScroller 
            Height          =   1420
            LargeChange     =   30
            Left            =   1575
            Max             =   0
            SmallChange     =   5
            TabIndex        =   36
            Top             =   0
            Width           =   225
         End
      End
      Begin VB.CommandButton RemoveFixPoint_btn 
         Caption         =   "&Remove last"
         Height          =   300
         Left            =   875
         TabIndex        =   28
         Top             =   300
         Width           =   1030
      End
      Begin VB.CommandButton AddFixPoint_btn 
         Caption         =   "&Add new"
         Height          =   300
         Left            =   90
         TabIndex        =   27
         Top             =   300
         Width           =   785
      End
   End
   Begin VB.Frame CantorSet_frm 
      Caption         =   "CantorSet Special:"
      Height          =   1130
      Left            =   5330
      TabIndex        =   37
      Top             =   2050
      Visible         =   0   'False
      Width           =   2000
      Begin VB.TextBox ElementsCount_txt 
         Alignment       =   2  'Zentriert
         Height          =   300
         Left            =   1250
         MaxLength       =   1
         TabIndex        =   42
         Text            =   "3"
         Top             =   700
         Width           =   500
      End
      Begin VB.TextBox StepHeight_txt 
         Alignment       =   2  'Zentriert
         Height          =   300
         Left            =   1000
         MaxLength       =   2
         TabIndex        =   39
         Text            =   "20"
         Top             =   350
         Width           =   500
      End
      Begin VB.Label ElementsCount_lbl 
         Caption         =   "ElementsCount:"
         Height          =   195
         Left            =   100
         TabIndex        =   41
         Top             =   750
         Width           =   1100
      End
      Begin VB.Label StepHeight_lbl 
         Caption         =   "StepHeight:"
         Height          =   195
         Left            =   100
         TabIndex        =   38
         Top             =   400
         Width           =   850
      End
      Begin VB.Label StepHeightDescription_lbl 
         Caption         =   "Pixel"
         Height          =   195
         Left            =   1530
         TabIndex        =   40
         Top             =   400
         Width           =   345
      End
   End
   Begin VB.Frame Cross_frm 
      Caption         =   "Cross Special:"
      Height          =   780
      Left            =   5330
      TabIndex        =   43
      Top             =   2050
      Visible         =   0   'False
      Width           =   2000
      Begin VB.TextBox DecreaseFactor_txt 
         Alignment       =   2  'Zentriert
         Height          =   300
         Left            =   1370
         TabIndex        =   45
         Text            =   "0.5"
         Top             =   350
         Width           =   500
      End
      Begin VB.Label DecreaseFactor_lbl 
         Caption         =   "DecreaseFactor:"
         Height          =   195
         Left            =   100
         TabIndex        =   44
         Top             =   400
         Width           =   1200
      End
   End
   Begin VB.Label Stripe_lbl 
      Appearance      =   0  '2D
      BackColor       =   &H80000011&
      BorderStyle     =   1  'Fest Einfach
      ForeColor       =   &H80000008&
      Height          =   120
      Left            =   3230
      TabIndex        =   3
      Top             =   210
      Width           =   4200
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'programmed by Anarki
'see Readme.txt for details

'<CodeStart>
Enum DM
   Recursive = 0
   ChaosGame = 1
   TurtleGraphics = 2
   Demo = 3
End Enum

Dim a As Integer
Dim LockResize As Boolean                 'Resize-Prozedur von MainForm sperren/lsen
Dim LockFractalType As Boolean            'FractalType_cmb_Click-Prozedur sperren/lsen
Dim AddWidth As Integer                   'zustzliche Breite bei geffneter ParameterBar
Dim FPAddX As Integer, FPAddY As Integer  'dienen zur richtigen Positionierung der FixPunkte
Dim LastActiveIndex As Integer            'Index des angewhlten FixPunktes
Dim FixPointsCount As Integer             'Buffer fr vorgegebene Anzahl von FixPunkten bei einigen Fraktaltypen (Sierpinsky-3)






'### FORM_LOADING & UNLOADING ############################################
Private Sub Form_Load()
LockResize = True
LockFractalType = True
LastActiveIndex = 0
ManageGlobalStates GS.Ready

InitSys
LoadUserINI

MainForm.Caption = "Fractality v" & App.Major & "." & App.Minor & Chr(App.Revision + 97)
PrintBackColorDescr
PrintForeColorDescr
LockResize = False
Form_Resize
LockFractalType = False
FractalType_cmb_Click
End Sub



Private Sub Form_Unload(Cancel As Integer)
If GlobalState <> GS.Ready Then
   MsgBoxResponse = MsgBox("Please abort the current operation first." _
                    , vbExclamation, "Not possible:")
   Cancel = 1
   Exit Sub
End If
SetPARAMS
SaveUserINI
Unload Me
End
End Sub
'##########################################################################






'### RESIZING #############################################################
Private Sub Form_Resize()
Const MinWidth = 3345: Const MaxWidth = 10845
Const MinHeight = 5085: Const MaxHeight = 10335

If WindowState = vbMinimized Then Exit Sub
If LockResize = True Then Exit Sub
LockResize = True

If Width <= MinWidth + AddWidth Then Width = MinWidth + AddWidth
If Width >= MaxWidth + AddWidth Then Width = MaxWidth + AddWidth
If Height <= MinHeight Then Height = MinHeight
If Height >= MaxHeight Then Height = MaxHeight

Output_pic.Width = ScaleWidth - (AddWidth + 200)
CommonParameter_frm.Left = Output_pic.Width + 200
DrawModes_frm.Left = CommonParameter_frm.Left + CommonParameter_frm.Width + 100
FixPoints_frm.Left = DrawModes_frm.Left
CantorSet_frm.Left = DrawModes_frm.Left
Cross_frm.Left = DrawModes_frm.Left
LSystem_frm.Left = DrawModes_frm.Left

FractalType_cmb.Width = (Output_pic.Width + 100) - (Draw_btn.Width + Params_btn.Width)
Draw_btn.Left = FractalType_cmb.Left + FractalType_cmb.Width
Params_btn.Left = Draw_btn.Left + Draw_btn.Width
Stripe_lbl.Left = Params_btn.Left + Params_btn.Width
Import_btn.Left = Stripe_lbl.Left + 900
Export_btn.Left = Import_btn.Left + Import_btn.Width

Output_pic.Height = ScaleHeight - (Output_pic.Top + 100 + StatusBar.Height)
CommonParameter_frm.Height = Output_pic.Height
FixPoints_frm.Height = (CommonParameter_frm.Top + CommonParameter_frm.Height) - FixPoints_frm.Top - 10
OutsideContainer_frm.Height = FixPoints_frm.Height - (OutsideContainer_frm.Top + 100)
FixPointsScroller.Height = OutsideContainer_frm.Height
ManageScroller

AreaWidth_txt.Text = Output_pic.ScaleWidth
AreaHeight_txt.Text = Output_pic.ScaleHeight

FixPointsCount = FixPoint_img.Count
ArrangeAllFixPoints

LockResize = False
End Sub
'##########################################################################






'### KEYACTIONS ################################################################
Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
Dim PicPath As String

Select Case KeyCode
Case vbKeyS
   If GlobalState = GS.Working Then ManageGlobalStates GS.Paused: Exit Sub
   If GlobalState = GS.Paused Then ManageGlobalStates GS.Working
Case vbKeyP    'Save Picture
   If Shift = 2 Then
      PicPath = SavePic(CommonDialog)
      If PicPath <> "" Then SavePicture Output_pic.Image, PicPath
   End If
End Select
End Sub
'##########################################################################







'### FRACTALSELECTION #####################################################
Private Sub FractalType_cmb_DropDown()
SetPARAMS
End Sub




Private Sub FractalType_cmb_Click()
If LockFractalType = True Then Exit Sub
Unload_tmr.Enabled = True
End Sub




Private Sub Unload_tmr_Timer()
AddFixPoint_btn.Enabled = True
RemoveFixPoint_btn.Enabled = True
ConnectLast_chk.Enabled = True

Select Case FractalType_cmb.ListIndex
Case FT.CantorSet
   If FixPoints_frm.Visible = False Then Call SpecialParams_btn_Click
   SpecialParams_btn.Enabled = True
   ManageDrawModes 1, 0, 0, 1
   
   AddFixPoint_btn.Enabled = False
   RemoveFixPoint_btn.Enabled = False
   ConnectLast_chk.Value = 0
   ConnectLast_chk.Enabled = False
   
   FixPointsCount = 1
   SetFixPointsCount
   For a = 0 To FixPointsCount
      XPos_txt(a).Text = PARAMS.CantorSet.Point(a).X
      YPos_txt(a).Text = PARAMS.CantorSet.Point(a).Y
   Next a
   DrawMode_opt(PARAMS.CantorSet.DrawMode).Value = True
   StepHeight_txt.Text = PARAMS.CantorSet.StepHeight
   ElementsCount_txt.Text = PARAMS.CantorSet.NewElementsCount
   
Case FT.Cross
   If FixPoints_frm.Visible = False Then Call SpecialParams_btn_Click
   SpecialParams_btn.Enabled = True
   ManageDrawModes 1, 0, 0, 0

   FixPointsCount = UBound(PARAMS.Cross.Point())
   SetFixPointsCount
   For a = 0 To FixPointsCount
      XPos_txt(a).Text = PARAMS.Cross.Point(a).X
      YPos_txt(a).Text = PARAMS.Cross.Point(a).Y
   Next a
   ConnectLast_chk.Value = IIf(PARAMS.Cross.ConnectLast = True, 1, 0)
   DrawMode_opt(PARAMS.Cross.DrawMode).Value = True
   DecreaseFactor_txt.Text = PARAMS.Cross.DecreaseFactor
   
Case FT.SierpinskyGadget
   If FixPoints_frm.Visible = False Then Call SpecialParams_btn_Click
   SpecialParams_btn.Enabled = False
   ManageDrawModes 1, 1, 0, 1
      
   AddFixPoint_btn.Enabled = False
   RemoveFixPoint_btn.Enabled = False
   ConnectLast_chk.Value = 1
   ConnectLast_chk.Enabled = False
   
   FixPointsCount = 2
   SetFixPointsCount
   For a = 0 To 2
      XPos_txt(a).Text = PARAMS.Sierpinsky.Point(a).X
      YPos_txt(a).Text = PARAMS.Sierpinsky.Point(a).Y
   Next a
   DrawMode_opt(PARAMS.Sierpinsky.DrawMode).Value = True
   
Case FT.KochCurve
   If FixPoints_frm.Visible = False Then Call SpecialParams_btn_Click
   SpecialParams_btn.Enabled = False
   ManageDrawModes 1, 0, 1, 0
   
   FixPointsCount = UBound(PARAMS.KochCurve.Point())
   SetFixPointsCount
   For a = 0 To FixPointsCount
      XPos_txt(a).Text = PARAMS.KochCurve.Point(a).X
      YPos_txt(a).Text = PARAMS.KochCurve.Point(a).Y
   Next a
   ConnectLast_chk.Value = IIf(PARAMS.KochCurve.ConnectLast = True, 1, 0)
   DrawMode_opt(PARAMS.KochCurve.DrawMode).Value = True

Case FT.LSystem
   If FixPoints_frm.Visible = False Then Call SpecialParams_btn_Click
   SpecialParams_btn.Enabled = True
   ManageDrawModes 0, 0, 1, 0
   
   AddFixPoint_btn.Enabled = False
   RemoveFixPoint_btn.Enabled = False
   ConnectLast_chk.Value = 0
   ConnectLast_chk.Enabled = False
   
   FixPointsCount = 1
   SetFixPointsCount
   For a = 0 To 1
      XPos_txt(a).Text = PARAMS.LSystem.Point(a).X
      YPos_txt(a).Text = PARAMS.LSystem.Point(a).Y
   Next a
   DrawMode_opt(DM.TurtleGraphics).Value = True
   
   Initiator_txt.Text = PARAMS.LSystem.Initiator
   Generator_txt.Text = PARAMS.LSystem.Generator
   LineLength_txt.Text = PARAMS.LSystem.LineLength
   Delta_txt.Text = PARAMS.LSystem.Delta
   
End Select

ArrangeAllFixPoints
If DrawMode_opt(DM.Demo).Value = True Then Output_pic.Cls

Unload_tmr.Enabled = False
End Sub



   Private Sub SetFixPointsCount()
   Dim b As Integer
   
   For b = FixPoint_img.Count To FixPointsCount
      Call AddFixPoint_btn_Click
   Next b
   For b = FixPoint_img.Count To FixPointsCount + 2 Step -1
      Call RemoveFixPoint_btn_Click
   Next b
   End Sub

   Private Sub ArrangeAllFixPoints()
   On Error Resume Next
   Dim b As Integer
   
   For b = 0 To FixPointsCount
      MoveFixPoint b, XPos_txt(b).Text, YPos_txt(b).Text
   Next b
   End Sub
'##########################################################################






'### FIXPOINTSSHIFTING ####################################################
Private Sub Output_pic_DblClick()
AddFixPoint_btn_Click
End Sub

Private Sub FixPoint_img_MouseDown(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
FPAddX = -Fix(X / Screen.TwipsPerPixelX)
FPAddY = -Fix(Y / Screen.TwipsPerPixelY)
ManageContainerSelection Index
FixPoint_img(Index).Drag vbBeginDrag
End Sub

Private Sub Output_pic_DragOver(Source As Control, X As Single, Y As Single, State As Integer)
If (Source.Name = "FixPoint_img") And (State = vbLeave) Then Source.Drag vbCancel
End Sub

Private Sub Output_pic_DragDrop(Source As Control, X As Single, Y As Single)
If Source.Name = "FixPoint_img" Then MoveFixPoint Source.Index, (X + FPAddX), (Y + FPAddY)
If (FractalType_cmb.ListIndex = FT.CantorSet) Then
   If Source.Index = 0 Then YPos_txt(1).Text = YPos_txt(0).Text
   If Source.Index = 1 Then YPos_txt(0).Text = YPos_txt(1).Text
   ArrangeAllFixPoints
End If
End Sub
'##########################################################################






'### BUTTONACTIONS #######################################################
Private Sub Draw_btn_Click()
Select Case GlobalState
Case GS.Ready
   ManageGlobalStates GS.Working
   SetPARAMS
   If PARAMS.General.PauseAfterStep = True Then ManageGlobalStates GS.Paused
   
   Draw_btn.Caption = "&Cancel"
   FractalType_cmb.Enabled = False
   Import_btn.Enabled = False
   CommonParameter_frm.Enabled = False
   DrawModes_frm.Enabled = False
   FixPoints_frm.Enabled = False
   CantorSet_frm.Enabled = False
   Cross_frm.Enabled = False
   LSystem_frm.Enabled = False
   For a = 0 To FixPoint_img.Count - 1
      FixPoint_img(a).Visible = False
   Next a
   
   DrawFractal FractalType_cmb.ListIndex

Case Else:
   Output_pic.Cls
   Output_pic.DrawWidth = 2
   If (DrawMode_opt(DM.ChaosGame).Value = False) And _
   (DrawMode_opt(DM.Demo).Value = False) Then _
      DrawConnectionLines
   
End Select

ManageGlobalStates GS.Ready

Draw_btn.Caption = "&Draw Fractal"
FractalType_cmb.Enabled = True
Import_btn.Enabled = True
CommonParameter_frm.Enabled = True
DrawModes_frm.Enabled = True
FixPoints_frm.Enabled = True
CantorSet_frm.Enabled = True
Cross_frm.Enabled = True
LSystem_frm.Enabled = True
If (DrawMode_opt(DM.ChaosGame).Value = False) And (DrawMode_opt(DM.Demo).Value = False) Then
   For a = 0 To FixPoint_img.Count - 1
      FixPoint_img(a).Visible = True
   Next a
End If
End Sub

   Private Sub SetPARAMS()
   'ValidateInputs

   PARAMS.General.ScaleW = AreaWidth_txt.Text
   PARAMS.General.ScaleH = AreaHeight_txt.Text
   PARAMS.General.Color = IIf(RandomForeColor_chk.Value = 1, -1, ForeColor_pic.BackColor)
   If (FractalType_cmb.ListIndex = FT.SierpinskyGadget) And (RandomForeColor_chk.Value = 0) And (DrawMode_opt(DM.Recursive).Value = True) Then PARAMS.General.Color = BackColor_pic.BackColor
   PARAMS.General.CalcDepth = CalcDepth_txt.Text
   PARAMS.General.PauseAfterStep = IIf(Pause_chk.Value = 1, True, False)
   
   Select Case FractalType_cmb.ListIndex
   Case FT.CantorSet
      PARAMS.CantorSet.DrawMode = GetDrawMode
      For a = 0 To 1
         PARAMS.CantorSet.Point(a).X = XPos_txt(a).Text
         PARAMS.CantorSet.Point(a).Y = YPos_txt(a).Text
      Next a
      PARAMS.CantorSet.StepHeight = StepHeight_txt.Text
      PARAMS.CantorSet.NewElementsCount = ElementsCount_txt.Text
      
   Case FT.Cross
      PARAMS.Cross.DrawMode = GetDrawMode
      ReDim PARAMS.Cross.Point(FixPoint_img.Count - 1)
      For a = 0 To FixPoint_img.Count - 1
         PARAMS.Cross.Point(a).X = XPos_txt(a).Text
         PARAMS.Cross.Point(a).Y = YPos_txt(a).Text
      Next a
      PARAMS.Cross.ConnectLast = IIf(ConnectLast_chk.Value = 1, True, False)
      PARAMS.Cross.DecreaseFactor = DecreaseFactor_txt.Text
      
   Case FT.SierpinskyGadget
      PARAMS.Sierpinsky.DrawMode = GetDrawMode
      For a = 0 To 2
         PARAMS.Sierpinsky.Point(a).X = XPos_txt(a).Text
         PARAMS.Sierpinsky.Point(a).Y = YPos_txt(a).Text
      Next a

   Case FT.KochCurve
      PARAMS.KochCurve.DrawMode = GetDrawMode
      ReDim PARAMS.KochCurve.Point(FixPoint_img.Count - 1)
      For a = 0 To FixPoint_img.Count - 1
         PARAMS.KochCurve.Point(a).X = XPos_txt(a).Text
         PARAMS.KochCurve.Point(a).Y = YPos_txt(a).Text
      Next a
      PARAMS.KochCurve.ConnectLast = IIf(ConnectLast_chk.Value = 1, True, False)

   Case FT.LSystem
      For a = 0 To 1
         PARAMS.LSystem.Point(a).X = XPos_txt(a).Text
         PARAMS.LSystem.Point(a).Y = YPos_txt(a).Text
      Next a
      PARAMS.LSystem.Initiator = Initiator_txt.Text
      PARAMS.LSystem.Generator = Generator_txt.Text
      PARAMS.LSystem.LineLength = LineLength_txt.Text
      PARAMS.LSystem.Delta = Delta_txt.Text
      
   End Select
   End Sub
      
      Private Function GetDrawMode() As Byte
      For a = 0 To DrawMode_opt.Count - 1
         If DrawMode_opt(a).Value = True Then GetDrawMode = a: Exit Function
      Next a
      End Function



Public Sub Params_btn_Click()
With Params_btn
   Select Case .Tag
   Case 0         'open
      .Caption = "<<& "
      .Tag = 1
      AddWidth = 4200
       Width = Width + 4200
   Case 1         'close
      .Caption = ">>& "
      .Tag = 0
      AddWidth = 0
      Width = Width - 4200
   End Select
End With
End Sub

'-------------------------------------------------------------------------------

Private Sub Import_btn_Click()
ImportFractalPARAMS
FractalType_cmb_Click
End Sub

Private Sub Export_btn_Click()
ExportFractalPARAMS
End Sub
'#########################################################################






'### COMMONPARAMETERACTIONS ###############################################
Private Sub AreaWidth_txt_GotFocus()
AreaWidth_txt.SelStart = 0
AreaWidth_txt.SelLength = Len(AreaWidth_txt.Text)
End Sub

Private Sub AreaWidth_txt_LostFocus()
If IsNumeric(AreaWidth_txt.Text) = False Then AreaWidth_txt.Text = 200
If (AreaWidth_txt.Text < 200) Then AreaWidth_txt.Text = 200
If AreaWidth_txt.Text > 700 Then AreaWidth_txt.Text = 700
SetFormSize
End Sub

Private Sub AreaHeight_txt_GotFocus()
AreaHeight_txt.SelStart = 0
AreaHeight_txt.SelLength = Len(AreaHeight_txt.Text)
End Sub

Private Sub AreaHeight_txt_LostFocus()
If IsNumeric(AreaHeight_txt.Text) = False Then AreaHeight_txt.Text = 250
If (AreaHeight_txt.Text < 250) Then AreaHeight_txt.Text = 250
If AreaHeight_txt.Text > 600 Then AreaHeight_txt.Text = 600
SetFormSize
End Sub
   
   Public Sub SetFormSize()
   Width = (Screen.TwipsPerPixelX * (AreaWidth_txt.Text + 2)) + 200 + AddWidth + 120
   Height = (Screen.TwipsPerPixelY * (AreaHeight_txt.Text + 2)) + Output_pic.Top + 100 + StatusBar.Height + 405
   End Sub
   
'-------------------------------------------------------------------------------

Private Sub BackColor_pic_Click()
CommonDialog.Color = BackColor_pic.BackColor
CommonDialog.Flags = cdlCCFullOpen + cdlCCRGBInit
CommonDialog.ShowColor
BackColor_pic.BackColor = CommonDialog.Color
Output_pic.BackColor = BackColor_pic.BackColor

PrintBackColorDescr
DrawConnectionLines
End Sub
   
   Private Sub PrintBackColorDescr()
   With BackColor_pic
      .CurrentX = (.ScaleWidth - .TextWidth("BackColor")) / 2
      .CurrentY = (.ScaleHeight - .TextHeight("BackColor")) / 2
      .ForeColor = vbWhite - .BackColor
      BackColor_pic.Print "BackColor"
   End With
   End Sub
   
Private Sub ForeColor_pic_Click()
CommonDialog.Color = ForeColor_pic.BackColor
CommonDialog.Flags = cdlCCFullOpen + cdlCCRGBInit
CommonDialog.ShowColor
ForeColor_pic.BackColor = CommonDialog.Color
Output_pic.ForeColor = ForeColor_pic.BackColor

PrintForeColorDescr
DrawConnectionLines
End Sub
   
   Private Sub PrintForeColorDescr()
   With ForeColor_pic
      .CurrentX = (.ScaleWidth - .TextWidth("BackColor")) / 2
      .CurrentY = (.ScaleHeight - .TextHeight("BackColor")) / 2
      .ForeColor = vbWhite - .BackColor
      ForeColor_pic.Print "ForeColor"
   End With
   End Sub

'-------------------------------------------------------------------------------

Private Sub CalcDepth_txt_GotFocus()
CalcDepth_txt.SelStart = 0
CalcDepth_txt.SelLength = Len(CalcDepth_txt.Text)
End Sub

Private Sub CalcDepth_txt_LostFocus()
If IsNumeric(CalcDepth_txt.Text) = False Then CalcDepth_txt.Text = 4: Exit Sub
If (CalcDepth_txt.Text < 0) Then CalcDepth_txt.Text = 0
End Sub

'-------------------------------------------------------------------------------

Private Sub SpecialParams_btn_Click()
If FixPoints_frm.Visible = True Then
   FixPoints_frm.Visible = False
   Select Case FractalType_cmb.ListIndex
   Case FT.CantorSet
      CantorSet_frm.Visible = True
   Case FT.Cross
      Cross_frm.Visible = True
   Case FT.LSystem
      LSystem_frm.Visible = True
   End Select
   SpecialParams_btn.Caption = "< &Switch to FixPoints <"
Else:
   CantorSet_frm.Visible = False
   Cross_frm.Visible = False
   FixPoints_frm.Visible = True
   LSystem_frm.Visible = False
   
   SpecialParams_btn.Caption = "> &Switch to Special >"
End If
End Sub
'##########################################################################






'### DRAWMODESACTIONS #####################################################
Private Sub DrawMode_opt_Click(Index As Integer)
ShowAllFixPoints

Select Case FractalType_cmb.ListIndex
Case FT.CantorSet
   Select Case Index
   Case DM.Recursive
      ElementsCount_lbl.Visible = True
      ElementsCount_txt.Visible = True
      SpecialParams_btn.Enabled = True
   Case DM.Demo
      HideAllFixPoints
      ElementsCount_lbl.Visible = False
      ElementsCount_txt.Visible = False
      CantorSet_frm.Visible = True
      SpecialParams_btn.Caption = "> &Switch to Special >"
      SpecialParams_btn.Enabled = False
   End Select
Case FT.SierpinskyGadget
   Select Case Index
   Case DM.Recursive
   Case DM.ChaosGame, DM.Demo: HideAllFixPoints
   End Select
Case FT.KochCurve
   Select Case Index
   Case DM.Recursive
      AddFixPoint_btn.Enabled = True
      RemoveFixPoint_btn.Enabled = True
      ConnectLast_chk.Enabled = True
   Case DM.TurtleGraphics
      AddFixPoint_btn.Enabled = False
      RemoveFixPoint_btn.Enabled = False
      ConnectLast_chk.Enabled = False
      FixPointsCount = 1
      SetFixPointsCount
   End Select
End Select
End Sub

   Private Sub ShowAllFixPoints()
   For a = 0 To FixPoint_img.Count - 1
      FixPoint_img(a).Visible = True
   Next a
   CantorSet_frm.Visible = False
   Cross_frm.Visible = False
   FixPoints_frm.Visible = True
   DrawConnectionLines
   End Sub
   
   Private Sub HideAllFixPoints()
   For a = 0 To FixPoint_img.Count - 1
      FixPoint_img(a).Visible = False
   Next a
   FixPoints_frm.Visible = False
   Output_pic.Cls
   End Sub




Private Sub ManageDrawModes(ParamArray DMStates())
On Error Resume Next
For a = 0 To DrawMode_opt.Count - 1
   DrawMode_opt(a).Enabled = IIf(DMStates(a) = 1, True, False)
Next a
End Sub
'##########################################################################






'### FIXPOINTSACTIONS #####################################################
Private Sub AddFixPoint_btn_Click()
Const MaxFixedPointsCount = 9
Dim NewIndex As Integer

NewIndex = FixPoint_img.Count

If NewIndex + 1 = MaxFixedPointsCount Then
   MsgBoxResponse = MsgBox("The maximal number of FixPoints is already reached", vbExclamation, "Adding impossible:")
   Exit Sub
End If

Load XPos_lbl(NewIndex)
Load XPos_txt(NewIndex)
Load YPos_lbl(NewIndex)
Load YPos_txt(NewIndex)

XPos_lbl(NewIndex).Top = XPos_lbl(NewIndex - 1).Top + 500
XPos_txt(NewIndex).Top = XPos_txt(NewIndex - 1).Top + 500
YPos_lbl(NewIndex).Top = XPos_lbl(NewIndex).Top
YPos_txt(NewIndex).Top = XPos_txt(NewIndex).Top
XPos_lbl(NewIndex).Caption = "X" & NewIndex + 1 & ":"
YPos_lbl(NewIndex).Caption = "Y" & NewIndex + 1 & ":"

ManageContainerSelection NewIndex
XPos_lbl(NewIndex).Visible = True
XPos_txt(NewIndex).Visible = True
YPos_lbl(NewIndex).Visible = True
YPos_txt(NewIndex).Visible = True
ConnectLast_chk.Top = ConnectLast_chk.Top + 500

ManageScroller
Load FixPoint_img(NewIndex)
MoveFixPoint NewIndex, CInt(XPos_txt(NewIndex - 1).Text) + 10, CInt(YPos_txt(NewIndex).Text)
FixPoint_img(NewIndex).Visible = True
End Sub




Private Sub RemoveFixPoint_btn_Click()
Dim NewIndex As Integer

NewIndex = FixPoint_img.Count - 1

If NewIndex = 1 Then
   MsgBoxResponse = MsgBox("The minimal number of FixPoints is reached", vbExclamation, "Removing impossible:")
   Exit Sub
End If

Unload XPos_lbl(NewIndex)
Unload XPos_txt(NewIndex)
Unload YPos_lbl(NewIndex)
Unload YPos_txt(NewIndex)
Unload FixPoint_img(NewIndex)
ConnectLast_chk.Top = ConnectLast_chk.Top - 500

ManageScroller
ManageContainerSelection NewIndex - 1
DrawConnectionLines
End Sub




   Private Sub ManageScroller()
   Dim HeightRest As Integer
   
   FixPointsScroller.Max = 0
   HeightRest = ConnectLast_chk.Top - (FixPointsScroller.Height - ConnectLast_chk.Height)
   If HeightRest > 0 Then
      FixPointsScroller.Max = Fix(HeightRest / Screen.TwipsPerPixelY)
      FixPointsScroller.Value = FixPointsScroller.Max
   End If
   FixPointsScroller.Refresh
   End Sub



'------------------------------------------------------------------------



Private Sub FixPointsScroller_Change()
InsideContainer_frm.Top = -FixPointsScroller.Value * Screen.TwipsPerPixelY
End Sub



'------------------------------------------------------------------------



Private Sub XPos_lbl_Click(Index As Integer)
XPos_txt(Index).SetFocus
End Sub

Private Sub XPos_txt_GotFocus(Index As Integer)
ManageContainerSelection Index
XPos_txt(Index).SelStart = 0
XPos_txt(Index).SelLength = Len(XPos_txt(Index).Text)
End Sub

Private Sub XPos_txt_LostFocus(Index As Integer)
If IsNumeric(XPos_txt(Index).Text) = False Then XPos_txt(Index).Text = 0
If (XPos_txt(Index).Text < 0) Then XPos_txt(Index).Text = 0
If Val(XPos_txt(Index).Text) > Val(AreaWidth_txt.Text) Then XPos_txt(Index).Text = AreaWidth_txt.Text
MoveFixPoint Index, XPos_txt(Index).Text, YPos_txt(Index).Text
End Sub



Private Sub YPos_lbl_Click(Index As Integer)
YPos_txt(Index).SetFocus
End Sub

Private Sub YPos_txt_GotFocus(Index As Integer)
ManageContainerSelection Index
YPos_txt(Index).SelStart = 0
YPos_txt(Index).SelLength = Len(YPos_txt(Index).Text)
End Sub

Private Sub YPos_txt_LostFocus(Index As Integer)
If IsNumeric(YPos_txt(Index).Text) = False Then YPos_txt(Index).Text = 0
If (YPos_txt(Index).Text < 0) Then YPos_txt(Index).Text = 0
If Val(YPos_txt(Index).Text) > Val(AreaHeight_txt.Text) Then YPos_txt(Index).Text = AreaHeight_txt.Text
MoveFixPoint Index, XPos_txt(Index).Text, YPos_txt(Index).Text

If (FractalType_cmb.ListIndex = FT.CantorSet) Then
   If Index = 0 Then YPos_txt(1).Text = YPos_txt(0).Text
   If Index = 1 Then YPos_txt(0).Text = YPos_txt(1).Text
   ArrangeAllFixPoints
End If
End Sub



Private Sub ConnectLast_chk_Click()
DrawConnectionLines
End Sub
'##########################################################################






'### CANTORSETACTIONS #####################################################
Private Sub StepHeight_txt_GotFocus()
StepHeight_txt.SelStart = 0
StepHeight_txt.SelLength = Len(StepHeight_txt.Text)
End Sub

Private Sub StepHeight_txt_LostFocus()
If IsNumeric(StepHeight_txt.Text) = False Then StepHeight_txt.Text = 10
End Sub

Private Sub ElementsCount_txt_GotFocus()
ElementsCount_txt.SelStart = 0
ElementsCount_txt.SelLength = Len(ElementsCount_txt.Text)
End Sub

Private Sub ElementsCount_txt_LostFocus()
If IsNumeric(ElementsCount_txt.Text) = False Then ElementsCount_txt.Text = 2: Exit Sub
If (ElementsCount_txt.Text < 2) Then ElementsCount_txt.Text = 2
End Sub
'##########################################################################






'### CROSSACTIONS ########################################################
Private Sub DecreaseFactor_txt_GotFocus()
DecreaseFactor_txt.SelStart = 0
DecreaseFactor_txt.SelLength = Len(DecreaseFactor_txt.Text)
End Sub

Private Sub DecreaseFactor_txt_LostFocus()
If IsNumeric(DecreaseFactor_txt.Text) = False Then DecreaseFactor_txt.Text = "0,5": Exit Sub
If (DecreaseFactor_txt.Text < 0) Then DecreaseFactor_txt.Text = 0
End Sub

Private Sub DecreaseFactor_txt_KeyPress(KeyAscii As Integer)
If KeyAscii = Asc(".") Then KeyAscii = Asc(",")
End Sub
'##########################################################################






'### LSYSTEMACTIONS ########################################################
Private Sub LineLength_txt_GotFocus()
LineLength_txt.SelStart = 0
LineLength_txt.SelLength = Len(LineLength_txt.Text)
End Sub

Private Sub LineLength_txt_LostFocus()
If IsNumeric(LineLength_txt.Text) = False Then LineLength_txt.Text = "0,5": Exit Sub
If (LineLength_txt.Text < 0) Then LineLength_txt.Text = 0
End Sub

Private Sub LineLength_txt_KeyPress(KeyAscii As Integer)
If KeyAscii = Asc(".") Then KeyAscii = Asc(",")
End Sub



Private Sub Delta_txt_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
On Error Resume Next
Delta_txt.ToolTipText = "=" & (CDbl(Delta_txt.Text) / 180) * PI & " (should lie somewhere between -6.2 and 6.2)"
End Sub

Private Sub Delta_txt_GotFocus()
Delta_txt.SelStart = 0
Delta_txt.SelLength = Len(Delta_txt.Text)
End Sub

Private Sub Delta_txt_LostFocus()
If IsNumeric(Delta_txt.Text) = False Then Delta_txt.Text = "50"
End Sub
'##########################################################################






'### COMMONFUNCTIONS ####################################################
Private Sub ValidateInputs()
On Error Resume Next

AreaWidth_txt.SetFocus
AreaHeight_txt.SetFocus
CalcDepth_txt.SetFocus

For a = 0 To FixPoint_img.Count - 1
   XPos_txt(a).SetFocus
   YPos_txt(a).SetFocus
Next a

StepHeight_txt.SetFocus
ElementsCount_txt.SetFocus

DecreaseFactor_txt.SetFocus
End Sub




Public Sub ManageGlobalStates(Optional NewState As Byte)
If IsMissing(NewState) = False Then GlobalState = NewState

With StatusBar.Panels
   .Item("GlobalState").Picture = GSIcon_pic(GlobalState).Picture

   Select Case GlobalState
   Case GS.Ready
      Output_pic.DrawWidth = 2
      .Item("GlobalState").ToolTipText = "EditMode"
      .Item("RecursionsCount").Visible = False
      .Item("ElementsCount").Visible = False
      .Item("Help").Text = "arrange the Fixpoint on the left to your desire"
   Case GS.Working
      Output_pic.DrawWidth = 1
      .Item("GlobalState").ToolTipText = "WorkingMode"
      If (DrawMode_opt(DM.ChaosGame).Value = False) And (DrawMode_opt(DM.TurtleGraphics).Value = False) And DrawMode_opt(DM.Demo).Value = False Then
         .Item("RecursionsCount").Text = "Recursions: 0"
         .Item("RecursionsCount").Visible = True
      End If
      .Item("ElementsCount").Text = "Elements drawn: 0"
      .Item("ElementsCount").Visible = True
      'If (FractalType_cmb.ListIndex = FT.CantorSet) And (DrawMode_opt(DM.Recursive).Value = True) Then .Item("LinesCount").Visible = True
      .Item("Help").Text = "pause with S"
   Case GS.Paused
      .Item("GlobalState").ToolTipText = "PauseMode"
      .Item("Help").Text = "resume with S"
   End Select
End With
End Sub




Private Sub ManageContainerSelection(CurIndex As Integer)
On Error GoTo ElementIsMissing

XPos_txt(LastActiveIndex).BackColor = vbWhite
YPos_txt(LastActiveIndex).BackColor = vbWhite

ResumingRoutine:
XPos_txt(CurIndex).BackColor = vbGreen
YPos_txt(CurIndex).BackColor = vbGreen
LastActiveIndex = CurIndex

'If XPos_txt(CurIndex).Top > FixPointsScroller.Height Then
'   FixPointsScroller.Value = Fix(XPos_txt(CurIndex).Top / Screen.TwipsPerPixelY)
'End If

Exit Sub
ElementIsMissing:
If Err.Number = 340 Then GoTo ResumingRoutine      '???
End Sub



 
Private Sub MoveFixPoint(ByVal CurIndex As Integer, CurLeft As Integer, CurTop As Integer)
If CurLeft < 0 Then CurLeft = 0
If CurLeft > (AreaWidth_txt.Text - 10) Then CurLeft = AreaWidth_txt.Text - 10
If CurTop < 0 Then CurTop = 0
If CurTop > (AreaHeight_txt.Text - 10) Then CurTop = AreaHeight_txt.Text - 10

FixPoint_img(CurIndex).Left = CurLeft
FixPoint_img(CurIndex).Top = CurTop
XPos_txt(CurIndex).Text = CurLeft
YPos_txt(CurIndex).Text = CurTop

DrawConnectionLines
End Sub

   Private Sub DrawConnectionLines()
   Dim X1 As Single, Y1 As Single, X2 As Single, Y2 As Single
   
   Output_pic.Cls
   For a = 1 To FixPoint_img.Count - 1
      X1 = FixPoint_img(a - 1).Left + (FixPoint_img(a - 1).Width / 2)
      Y1 = FixPoint_img(a - 1).Top + (FixPoint_img(a - 1).Height / 2)
      X2 = FixPoint_img(a).Left + (FixPoint_img(a).Width / 2)
      Y2 = FixPoint_img(a).Top + (FixPoint_img(a).Height / 2)
   
      Output_pic.Line (X1, Y1)-(X2, Y2)
      
      Output_pic.CurrentX = FixPoint_img(a - 1).Left - 2
      Output_pic.CurrentY = FixPoint_img(a - 1).Top + FixPoint_img(a - 1).Height
      Output_pic.Print Str(a)
   Next a
   
   Output_pic.CurrentX = FixPoint_img(a - 1).Left - 2
   Output_pic.CurrentY = FixPoint_img(a - 1).Top + FixPoint_img(a - 1).Height
   Output_pic.Print Str(a)
   
   If ConnectLast_chk.Value = 1 Then
      X1 = FixPoint_img(0).Left + (FixPoint_img(0).Width / 2)
      Y1 = FixPoint_img(0).Top + (FixPoint_img(0).Height / 2)
      Output_pic.Line (X1, Y1)-(X2, Y2)
   End If
   End Sub
'##########################################################################
