VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "TurtleGraphicsCls"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'<CodeStart>
Private Type State
   X As Double
   Y As Double
   Alpha As Double
End Type
Dim State As State
Dim OldState As State
Dim Stack() As State
Dim StackSize As Integer

Public InitiatorString As String
Public GeneratorString As String
Public Distance As Double
Public Delta As Double
Public Depth As Integer

Dim a As Long






Public Sub SetStartStates(X As Double, Y As Double, Alpha As Double)
State.X = X
State.Y = Y
State.Alpha = Alpha
End Sub




Public Sub Draw()
StackSize = -1
If Depth > 7 Then Depth = 7

CreateFullString
InterpretString
End Sub
   
   Private Sub CreateFullString()
   For a = 1 To Depth
      InitiatorString = Replace(InitiatorString, "F", GeneratorString)
   Next a
   End Sub
   
   Private Sub InterpretString()
   For a = 1 To Len(InitiatorString)
      If GlobalState = GS.Paused Then PauseMode
      If GlobalState = GS.Ready Then Exit Sub
   
      InterpretSymbol Mid(InitiatorString, a, 1)
      
      IncreaseElementsCount 1
      DoEvents
   Next a
   End Sub
   
      Private Sub InterpretSymbol(CurSymbol As String)
      Select Case CurSymbol
      Case "F"    'move forward and draw
         OldState.X = State.X
         OldState.Y = State.Y
         State.X = State.X + Distance * Cos(State.Alpha)
         State.Y = State.Y + Distance * Sin(State.Alpha)
         OutputPointer.Line (OldState.X, OldState.Y)-(State.X, State.Y), GetColor
      Case "f"    'jump forward without drawing
         State.X = State.X + Distance * Cos(State.Alpha)
         State.Y = State.Y + Distance * Sin(State.Alpha)
      Case "+"    'turn right
         State.Alpha = State.Alpha + Delta
      Case "-"    'turn left
         State.Alpha = State.Alpha - Delta
      Case "["    'push onto stack
         StackSize = StackSize + 1
         ReDim Preserve Stack(StackSize)
         Stack(StackSize).X = State.X
         Stack(StackSize).Y = State.Y
         Stack(StackSize).Alpha = State.Alpha
      Case "]"    'pop from stack
         State.X = Stack(StackSize).X
         State.Y = Stack(StackSize).Y
         State.Alpha = Stack(StackSize).Alpha
         If StackSize > 0 Then StackSize = StackSize - 1
         ReDim Preserve Stack(StackSize)
      End Select
      End Sub
